﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Windykacja" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML><HEAD><title>Historia Windykacji</title>
<script runat="server">
            private SprawaWindykacyjna Sprawa { get; set; }

            void OnContextLoad(Object sender, EventArgs args) {
                Sprawa = (SprawaWindykacyjna)dc[typeof(SprawaWindykacyjna)];
                ReportHeader.Title = String.Format(ReportHeader.Title, Sprawa.Numer);
                StanNaDzien.EditValue = Date.Today;
                GridHistoria.DataSource = DataSource;
                GridPozycje.DataSource = Sprawa.Pozycje;

            }

            public Soneta.Windykacja.Windykacja[] DataSource
            {
                get
                {
                    if (Sprawa == null) return null;

                    var result = new List<Soneta.Windykacja.Windykacja>();
                    var windykacjeSprawy = from naleznosc in Sprawa.Pozycje.Select(p => p.Naleznosc)
                                           from windykacja in naleznosc.HistoriaWindykacji
                                           where windykacja.Sprawa == Sprawa 
                                                && !windykacja.Nazwa.EndsWith(" - zmiana na kolejny etap")
                                                && !windykacja.Nazwa.EndsWith(" - ominięcie etapu")
                                                && !windykacja.Nazwa.EndsWith(" - anulowanie sprawy")
                                                && !windykacja.Nazwa.EndsWith(" - zakończenie sprawy")
                                                && windykacja.Data <= Date.Today
                                           select windykacja;

                    foreach (var windykacja in windykacjeSprawy.Where(windykacja => !result.Any(p => AreEqual(p, windykacja))))
                    {
                        result.Add(windykacja);
                    }

                    return result.ToArray();
                }
            }

            private static bool AreEqual(Soneta.Windykacja.Windykacja w1, Soneta.Windykacja.Windykacja w2)
            {
                return w1.Typ == w2.Typ && w1.Sprawa == w2.Sprawa && w1.Data == w2.Data
                       && w1.Termin == w2.Termin && w1.Nazwa == w2.Nazwa && w1.Notatka.ToString() == w2.Notatka.ToString();
            }
        </script>
</HEAD>
<BODY>
<FORM id=form method=post runat="server"><ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad" />
<eb:ReportHeader id="ReportHeader" runat="server" title="Historia sprawy {0}" DataMember0="." />
<p style="font-family:Tahoma; font-size:small">Stan na dzień: <strong><ea:DataLabel runat="server" id="StanNaDzien" /></strong></p>
<p style="font-family:Tahoma; font-size:small"><strong>Płatności objęte sprawą:</strong></p>
<ea:Grid runat="server" id="GridPozycje" GroupData0="Naleznosc.DoRozliczenia.Symbol" GroupLine="Waluta: {0}" ShowSum="Never" ShowGroupSum="true" GroupSumText="Suma:">
   <Columns>
      <ea:GridColumn Width="5" Align="Right" DataMember="Lp" Caption="LP" runat="server" />
      <ea:GridColumn           Align="Left" DataMember="Naleznosc.NumerDokumentu" Caption="Dokument" runat="server" />
      <ea:GridColumn Width="12" Align="Center" DataMember="Naleznosc.DataDokumentu" Caption="Data" runat="server" />
      <ea:GridColumn Width="12" Align="Center" DataMember="Naleznosc.Termin" Caption="Termin" runat="server" Total="Info" />
      <ea:GridColumn Width="20" Align="Right" DataMember="Naleznosc.Kwota" Caption="Kwota" runat="server" Total="Sum" />
      <ea:GridColumn Width="20" Align="Right" DataMember="Naleznosc.DoRozliczenia" Caption="Kwota do rozliczenia" runat="server" Total="Sum" />
   </Columns>
</ea:Grid>
<p style="font-family:Tahoma; font-size:small"><strong>Wykaz czynności na sprawie:</strong></p>
<ea:Grid runat="server" id="GridHistoria">
   <Columns>
      <ea:GridColumn Width="5" Align="Right" DataMember="#" Caption="LP" runat="server" />
      <ea:GridColumn Width="43" Align="Left" DataMember="Nazwa" Caption="Zrealizowane zadanie" runat="server" />
      <ea:GridColumn Width="12" Align="Center" DataMember="Data" Caption="Data wykonania" runat="server" />
      <ea:GridColumn           Align="Left" DataMember="Notatka" Caption="Notatka" runat="server" />
   </Columns>
</ea:Grid>
<eb:ReportFooter id="ReportFooter" runat="server" />
</FORM></BODY></HTML>
